/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.StorageMod;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class TileEntityPainted
extends TileEntity {
    public static final ModelProperty<Supplier<BlockState>> FACADE_STATE = new ModelProperty();
    private BlockState blockState;

    public TileEntityPainted() {
        super(StorageMod.paintedTile);
    }

    public TileEntityPainted(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public boolean setPaintedBlockState(BlockState blockState) {
        boolean changed;
        BlockState old = this.getPaintedBlockState();
        this.blockState = blockState;
        boolean bl = changed = !this.getPaintedBlockState().equals(old);
        if (changed) {
            this.markDirtyClient();
        }
        return changed;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FACADE_STATE, this::getPaintedBlockState).build();
    }

    public void func_230337_a_(BlockState st, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(st, compound);
        this.blockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("block"));
        this.markDirtyClient();
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        if (this.blockState != null) {
            compound.func_218657_a("block", (INBT)NBTUtil.func_190009_a((BlockState)this.blockState));
        }
        return super.func_189515_b(compound);
    }

    private void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public BlockState getPaintedBlockState() {
        return this.blockState == null ? Blocks.field_150350_a.func_176223_P() : this.blockState;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        BlockState old = this.getPaintedBlockState();
        CompoundNBT tagCompound = packet.func_148857_g();
        super.onDataPacket(net, packet);
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), tagCompound);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !this.getPaintedBlockState().equals(old)) {
            this.field_145850_b.func_175646_b(this.func_174877_v(), this.getTileEntity());
        }
    }
}

